#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct Cone
{
    float cosa;
    float h;
    vec3 c;
    vec3 v;
};

struct Ray
{
    vec3 o;
    vec3 d;
};

struct BasicDeferredParams
{
    mat4 mModel;
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_projection_params;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct DeferredRenderLightsParams
{
    vec2 frustum_shift;
    vec2 resolution;
    int lights_num;
    float env_map_intensity;
    float raytrace_scaling_factor;
    float raytrace_strength;
};

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float volumetric_fog_luminance_ceiling;
    uint volumetric_fog_blend_function;
    float _pad1;
    float _pad2;
    vec4 volumetric_fog_tint;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float volumetric_light_strength;
    float volumetric_light_fog_density;
    float volumetric_light_fog_height;
    vec2 taa_jitter;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 2, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _424;

layout(set = 1, binding = 3, std140) uniform DeferredRenderLightsParamsBuffer
{
    DeferredRenderLightsParams render_lights_params;
} _836;

layout(set = 1, binding = 4, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _1045;

layout(set = 1, binding = 5, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 6, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1514;

layout(set = 1, binding = 7) uniform sampler2D s_Gradients;
layout(set = 1, binding = 8) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 24) uniform sampler2D LightProjectorSamplers[16];
layout(set = 1, binding = 40) uniform sampler2D sAlbedo;
layout(set = 1, binding = 41) uniform usampler2D sNormalMaterial;
layout(set = 1, binding = 42) uniform sampler2D sDepth;
layout(set = 1, binding = 43) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 44) uniform sampler2D sEmissive;
layout(set = 1, binding = 45) uniform sampler2DArray s_BlueNoise;

layout(location = 0) out vec4 outColor;
layout(location = 1) in vec4 vFrustum;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _226;
    if (nor.x > 0.0)
    {
        _226 = -t;
    }
    else
    {
        _226 = t;
    }
    nor.x += _226;
    float _241;
    if (nor.y > 0.0)
    {
        _241 = -t;
    }
    else
    {
        _241 = t;
    }
    nor.y += _241;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _424.basic_params.camera_near_far_plane.z / (_424.basic_params.camera_near_far_plane.y - (d * _424.basic_params.camera_near_far_plane.w));
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_836.render_lights_params.frustum_shift * _836.render_lights_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_424.basic_params.camera_projection_params.z) + ((_424.basic_params.camera_projection_params.x * vd_pos.x) / _836.render_lights_params.resolution.x);
    view_direction.y = (-_424.basic_params.camera_projection_params.w) + ((_424.basic_params.camera_projection_params.y * vd_pos.y) / _836.render_lights_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

float frustum_far_plane()
{
    return _424.basic_params.camera_near_far_plane.y;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float fog_density_for_position(vec3 p)
{
    return exp((-p.y) / _1045.composite_setup.volumetric_light_fog_height);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 light_calculate_spot_attenuation_color(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float angle_falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    vec3 attenuation_color = vec3(0.0);
    bool _366 = angle_falloff > cutoff;
    bool _373;
    if (_366)
    {
        _373 = light_distance < light.range;
    }
    else
    {
        _373 = _366;
    }
    if (_373)
    {
        float angle_cos = 1.0 - ((1.0 - angle_falloff) / (1.0 - cutoff));
        attenuation_color = vec3(1.0);
        if (light.angular_falloff_color_gradient_idx != (-1))
        {
            int param = light.angular_falloff_color_gradient_idx;
            float param_1 = 1.0 - angle_cos;
            attenuation_color = gradient_sample(param, param_1).xyz;
        }
        float angle_attenuation = pow(angle_cos, light.angular_falloff_power);
        float distance_attenuation = 1.0 - (light_distance / light.range);
        attenuation_color *= ((angle_attenuation * distance_attenuation) * distance_attenuation);
    }
    return attenuation_color;
}

float volumetric_sample_shadow_all_lights(ivec2 screen_pos, vec2 jitterHash, vec3 frustum, float frustum_depth, float max_depth, out float attenuation, inout vec3 color)
{
    float fact = 0.0;
    float t = 0.0;
    attenuation = 0.0;
    color = vec3(0.0);
    float fog_density = _1045.composite_setup.volumetric_light_fog_density;
    float scattering_shadow_falloff_distance = 1400.0;
    int samples_num = 0;
    t += (jitterHash.x * 0.0052083334885537624359130859375);
    for (int i = 0; i < 192; i++)
    {
        vec2 param = vec2(screen_pos);
        vec3 view_direction = get_view_direction(param);
        float view_depth_step = 0.0052083334885537624359130859375;
        float view_depth = t * frustum_depth;
        if (view_depth > max_depth)
        {
            break;
        }
        vec3 param_1 = view_direction;
        float param_2 = view_depth;
        vec3 param_3 = positionFromDepth(param_1, param_2);
        mat4 param_4 = _424.basic_params.mModel;
        vec3 _1103 = vector_transform_by_mat43(param_3, param_4);
        vec3 ray_world = _1103;
        float lf = 0.0;
        vec3 param_5 = ray_world;
        float local_fog_density = fog_density * fog_density_for_position(param_5);
        for (int light_idx = 0; light_idx < _836.render_lights_params.lights_num; light_idx++)
        {
            LightProperties _1134;
            _1134.diffuse = lights.light_properties[light_idx].diffuse;
            _1134.direction = lights.light_properties[light_idx].direction;
            _1134.position = lights.light_properties[light_idx].position;
            _1134.up = lights.light_properties[light_idx].up;
            _1134.right = lights.light_properties[light_idx].right;
            _1134.dimensions = lights.light_properties[light_idx].dimensions;
            _1134.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
            _1134.intensity = lights.light_properties[light_idx].intensity;
            _1134.range = lights.light_properties[light_idx].range;
            _1134.cutoff = lights.light_properties[light_idx].cutoff;
            _1134.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _1134.is_area = lights.light_properties[light_idx].is_area;
            _1134.type = lights.light_properties[light_idx].type;
            _1134.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _1134.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _1134.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
            _1134.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _1134.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _1134.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _1134.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _1134.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _1134.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _1134.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _1134.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _1134.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
            _1134.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
            _1134.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _1134.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _1134.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _1134.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _1134.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _1134.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _1134.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _1134.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _1134.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _1134;
            vec3 light_color = vec3(0.0);
            float falloff = dot(light.direction, normalize(ray_world - light.position));
            if ((light.type & 64) == 0)
            {
                falloff = 0.0;
            }
            if (falloff > light.cutoff)
            {
                LightProperties param_6 = light;
                vec3 param_7 = ray_world;
                vec3 light_attenuation_color = light_calculate_spot_attenuation_color(param_6, param_7);
                vec4 projector = vec4(1.0);
                vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(ray_world, 1.0);
                bool is_in_frustum = true;
                if (vShadowCoords.w <= 0.0)
                {
                    is_in_frustum = false;
                }
                else
                {
                    bool _1187 = vShadowCoords.x < (-vShadowCoords.w);
                    bool _1196;
                    if (!_1187)
                    {
                        _1196 = vShadowCoords.x > vShadowCoords.w;
                    }
                    else
                    {
                        _1196 = _1187;
                    }
                    bool _1206;
                    if (!_1196)
                    {
                        _1206 = vShadowCoords.y < (-vShadowCoords.w);
                    }
                    else
                    {
                        _1206 = _1196;
                    }
                    bool _1215;
                    if (!_1206)
                    {
                        _1215 = vShadowCoords.y > vShadowCoords.w;
                    }
                    else
                    {
                        _1215 = _1206;
                    }
                    if (_1215)
                    {
                        is_in_frustum = false;
                    }
                }
                float shadow_value = 0.0;
                if (is_in_frustum)
                {
                    vec4 sample_coords = vShadowCoords;
                    vec4 _1224 = sample_coords;
                    float _1228 = sample_coords.w;
                    vec2 _1230 = (_1224.xy * vec2(0.5)) + (vec2(0.5) * _1228);
                    sample_coords.x = _1230.x;
                    sample_coords.y = _1230.y;
                    sample_coords.y /= sample_coords.w;
                    sample_coords.y = 1.0 - sample_coords.y;
                    sample_coords.y *= sample_coords.w;
                    vec4 _1255 = sample_coords;
                    vec4 _1258 = _1255;
                    _1258.z = _1255.w;
                    shadow_value = textureProj(LightShadowmapCmpSamplers[light.downsampled_shadowmap_sampler], vec4(_1258.xy, _1255.z, _1258.z));
                    light_attenuation_color *= (1.0 - shadow_value);
                    if ((light.type & 16) != 0)
                    {
                        vec2 projected_sample_coords = sample_coords.xy / vec2(sample_coords.w);
                        vec3 _1293 = textureLod(LightProjectorSamplers[light.projector_sampler], projected_sample_coords, 1.5).xyz * light.projector_intensity;
                        projector.x = _1293.x;
                        projector.y = _1293.y;
                        projector.z = _1293.z;
                    }
                }
                lf += (1.0 - shadow_value);
                float af = 1.0 - exp((-local_fog_density) * view_depth_step);
                color += (((((light.diffuse.xyz * light.intensity) * projector.xyz) * light_attenuation_color) * af) * 1.0);
                samples_num++;
            }
        }
        fact += ((lf * local_fog_density) * view_depth_step);
        t += view_depth_step;
    }
    return fact / (192.0 * float(_836.render_lights_params.lights_num));
}

float sampleShadowDist(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, inout vec4 projector_color, inout float shadow_dist)
{
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 0.0;
    }
    bool _459 = coords.x < (-coords.w);
    bool _468;
    if (!_459)
    {
        _468 = coords.x > coords.w;
    }
    else
    {
        _468 = _459;
    }
    bool _478;
    if (!_468)
    {
        _478 = coords.y < (-coords.w);
    }
    else
    {
        _478 = _468;
    }
    bool _487;
    if (!_478)
    {
        _487 = coords.y > coords.w;
    }
    else
    {
        _487 = _478;
    }
    if (_487)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _491 = coords;
    float _496 = coords.w;
    vec2 _498 = (_491.xy * vec2(0.5)) + (vec2(0.5) * _496);
    coords.x = _498.x;
    coords.y = _498.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    vec4 _528 = coords;
    vec4 _531 = _528;
    _531.z = _528.w;
    float shadow = textureProj(smpl, vec4(_531.xy, _528.z, _531.z));
    projector_color = vec4(1.0);
    shadow_dist = 0.0;
    return shadow;
}

float calculate_shadow_dist_for_position(LightProperties light, vec3 world, float depth, out vec4 cascadeColor, inout vec4 projector_color, out float shadow_dist)
{
    vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
    cascadeColor = vec4(1.0, 0.100000001490116119384765625, 0.100000001490116119384765625, 1.0);
    vec4 param = vShadowCoords;
    float param_1;
    vec4 param_2;
    float param_3;
    float _564 = sampleShadowDist(LightShadowmapCmpSamplers[light.downsampled_shadowmap_sampler], param, param_1, param_2, param_3);
    float in_frustum = param_1;
    projector_color = param_2;
    shadow_dist = param_3;
    float shadow = _564;
    shadow *= in_frustum;
    projector_color *= in_frustum;
    return shadow;
}

float volumetric_sample_shadow_spot(LightProperties light, ivec2 screen_pos, vec2 jitterHash, vec3 frustum, float max_depth, inout float attenuation, inout vec4 projector_color)
{
    float fact = 0.0;
    float depth_dir = 0.100000001490116119384765625;
    float depth_pos = 0.0;
    attenuation = 0.0;
    depth_pos += ((depth_dir * jitterHash.x) * 1000.0);
    int i = 0;
    vec4 param_6;
    vec4 param_7;
    float param_8;
    for (; i < 256; i++)
    {
        vec2 param = vec2(screen_pos);
        vec3 view_direction = get_view_direction(param);
        vec3 param_1 = view_direction;
        float param_2 = depth_pos;
        vec3 ray_world = (_424.basic_params.mModel * vec4(positionFromDepth(param_1, param_2), 1.0)).xyz;
        float lf = 0.0;
        float falloff = dot(light.direction, normalize(ray_world - light.position));
        if (falloff > light.cutoff)
        {
            float sample_attenuation = 1.0 - ((1.0 - falloff) / (1.0 - light.cutoff));
            sample_attenuation *= (1.0 - clamp(length(light.position - ray_world) / light.range, 0.0, 1.0));
            sample_attenuation = pow(sample_attenuation, 3.0);
            LightProperties param_3 = light;
            vec3 param_4 = ray_world;
            float param_5 = depth_pos;
            float _974 = calculate_shadow_dist_for_position(param_3, param_4, param_5, param_6, param_7, param_8);
            vec4 cascade_color = param_6;
            vec4 projector = param_7;
            float shadow_dist = param_8;
            float shadow_value = _974;
            lf = sample_attenuation * shadow_value;
            attenuation += sample_attenuation;
            vec4 _991 = projector_color;
            vec3 _993 = _991.xyz + ((projector.xyz * (1.0 - shadow_value)) * sample_attenuation);
            projector_color.x = _993.x;
            projector_color.y = _993.y;
            projector_color.z = _993.z;
        }
        fact += lf;
        depth_dir *= 1.0299999713897705078125;
        depth_pos += depth_dir;
        if (depth_pos > max_depth)
        {
            break;
        }
    }
    vec4 _1020 = projector_color;
    vec3 _1023 = _1020.xyz / vec3(float(i + 1));
    projector_color.x = _1023.x;
    projector_color.y = _1023.y;
    projector_color.z = _1023.z;
    return (attenuation - fact) / float(i + 1);
}

bool inside_light_cone(vec3 p0, vec3 p, float angle, float height)
{
    float hsquared = height * height;
    float cosangle = angle;
    float cDistance = dot(p, p);
    bool _589 = cDistance <= hsquared;
    bool _600;
    if (_589)
    {
        _600 = dot(p0, p) >= (sqrt(cDistance) * cosangle);
    }
    else
    {
        _600 = _589;
    }
    return _600;
}

bool intersect_cone(Cone s, Ray r, float max_t, out float v, out vec2 intersections)
{
    v = 0.0;
    intersections = vec2(0.0);
    vec3 param = s.v;
    vec3 param_1 = r.o - s.c;
    float param_2 = s.cosa;
    float param_3 = s.h;
    bool is_inside = inside_light_cone(param, param_1, param_2, param_3);
    vec3 co = r.o - s.c;
    float a = (dot(r.d, s.v) * dot(r.d, s.v)) - (s.cosa * s.cosa);
    float b = 2.0 * ((dot(r.d, s.v) * dot(co, s.v)) - ((dot(r.d, co) * s.cosa) * s.cosa));
    float c = (dot(co, s.v) * dot(co, s.v)) - ((dot(co, co) * s.cosa) * s.cosa);
    float det = (b * b) - ((4.0 * a) * c);
    if (det < 0.0)
    {
        return false;
    }
    det = sqrt(det);
    float t1 = ((-b) - det) / (2.0 * a);
    float t2 = ((-b) + det) / (2.0 * a);
    intersections = vec2(t1, t2);
    if (is_inside)
    {
        return true;
    }
    float t = t1;
    bool _734 = t < 0.0;
    bool _744;
    if (!_734)
    {
        _744 = (t2 > 0.0) && (t2 < t);
    }
    else
    {
        _744 = _734;
    }
    if (_744)
    {
        t = t2;
    }
    if (t < 0.0)
    {
        return false;
    }
    vec3 cp = (r.o + (r.d * t)) - s.c;
    float h = dot(cp, s.v);
    if (h < 0.0)
    {
        cp = (r.o + (r.d * max(t1, t2))) - s.c;
        h = dot(cp, s.v);
        if (h < 0.0)
        {
            return false;
        }
    }
    if (h < s.h)
    {
        return true;
    }
    cp = (r.o + (r.d * max(t1, t2))) - s.c;
    h = dot(cp, s.v);
    bool _818 = h > 0.0;
    bool _825;
    if (_818)
    {
        _825 = h < s.h;
    }
    else
    {
        _825 = _818;
    }
    if (_825)
    {
        return true;
    }
    return false;
}

void main()
{
    ivec2 screen_pos = ivec2(gl_FragCoord.xy);
    vec4 base_color = texelFetch(sAlbedo, screen_pos, 0);
    uint encoded_normal_material = texelFetch(sNormalMaterial, screen_pos, 0).x;
    uint param = encoded_normal_material;
    vec3 _1378 = decode_normal(param);
    vec3 vNorm = _1378;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    float param_2 = texelFetch(sDepth, screen_pos, 0).x;
    float depth = linearizeDepth(param_2);
    vec2 param_3 = vec2(screen_pos);
    vec3 view_direction = get_view_direction(param_3);
    vec3 param_4 = view_direction;
    float param_5 = depth;
    vec3 world = (_424.basic_params.mModel * vec4(positionFromDepth(param_4, param_5), 1.0)).xyz;
    outColor = vec4(0.0);
    uvec4 param_6 = texelFetch(sMetalnessRoughnessMaterialTags, screen_pos, 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_6);
    float metalness = metalness_roughness_material_tags.metalness;
    float roughness = metalness_roughness_material_tags.roughness;
    uint material = metalness_roughness_material_tags.material_index;
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    if ((material_flags & 4096u) != 0u)
    {
        outColor = base_color;
        outColor.w = 0.0;
        return;
    }
    vec3 base_emissive = texelFetch(sEmissive, screen_pos, 0).xyz * materials.material_properties[material].emissive;
    bool is_background = (materialId & 1) == 1;
    bool is_particle = (material_flags & 8192u) != 0u;
    vec3 view = normalize(_424.basic_params.camera_position - world);
    vec3 outLightColor = vec3(0.0);
    float outOpacity = 0.0;
    bool use_all_lights = true;
    if (use_all_lights == true)
    {
        vec2 jitterHash = texelFetch(s_BlueNoise, ivec3(screen_pos & ivec2(127), _1514.globals.monotonic & 15), 0).xy;
        float attenuation = 0.0;
        vec3 volume_color = vec3(0.0);
        ivec2 param_7 = screen_pos;
        vec2 param_8 = jitterHash;
        vec3 param_9 = vFrustum.xyz;
        float param_10 = frustum_far_plane();
        float param_11 = depth;
        float param_12;
        vec3 param_13;
        float _1542 = volumetric_sample_shadow_all_lights(param_7, param_8, param_9, param_10, param_11, param_12, param_13);
        attenuation = param_12;
        volume_color = param_13;
        float volume_attenuation = _1542;
        outLightColor = volume_color;
        outOpacity = volume_attenuation;
    }
    if (use_all_lights == false)
    {
        float param_19;
        vec4 param_20;
        float param_24;
        vec2 param_25;
        for (int light_idx = 0; light_idx < _836.render_lights_params.lights_num; light_idx++)
        {
            LightProperties _1565;
            _1565.diffuse = lights.light_properties[light_idx].diffuse;
            _1565.direction = lights.light_properties[light_idx].direction;
            _1565.position = lights.light_properties[light_idx].position;
            _1565.up = lights.light_properties[light_idx].up;
            _1565.right = lights.light_properties[light_idx].right;
            _1565.dimensions = lights.light_properties[light_idx].dimensions;
            _1565.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
            _1565.intensity = lights.light_properties[light_idx].intensity;
            _1565.range = lights.light_properties[light_idx].range;
            _1565.cutoff = lights.light_properties[light_idx].cutoff;
            _1565.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _1565.is_area = lights.light_properties[light_idx].is_area;
            _1565.type = lights.light_properties[light_idx].type;
            _1565.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _1565.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _1565.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
            _1565.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _1565.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _1565.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _1565.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _1565.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _1565.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _1565.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _1565.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _1565.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
            _1565.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
            _1565.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _1565.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _1565.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _1565.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _1565.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _1565.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _1565.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _1565.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _1565.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _1565;
            if ((light.lighting_exclusion_tags & metalness_roughness_material_tags.component_tags) != 0u)
            {
                continue;
            }
            vec3 light_color = vec3(0.0);
            if ((light.type & 2) != 0)
            {
                if ((light.type & 64) != 0)
                {
                    Cone cone = Cone(light.cutoff * 1.0, light.range * 2.0, light.position, light.direction);
                    Ray ray = Ray(_424.basic_params.camera_position, normalize(vFrustum.xyz));
                    float max_t = depth;
                    float vv = 0.0;
                }
            }
            vec3 pointToLight = light.position - world;
            if ((light.type & 1) != 0)
            {
                pointToLight = -light.direction;
            }
            SPIRV_CROSS_BRANCH
            if ((light.type & 64) != 0)
            {
                vec2 jitterHash_1 = texelFetch(s_BlueNoise, ivec3(screen_pos & ivec2(127), (_1514.globals.monotonic + light_idx) & 15), 0).xy;
                float attenuation_1 = 0.0;
                vec4 projector_color = vec4(0.0);
                LightProperties param_14 = light;
                ivec2 param_15 = screen_pos;
                vec2 param_16 = jitterHash_1;
                vec3 param_17 = vFrustum.xyz;
                float param_18 = depth;
                float _1661 = volumetric_sample_shadow_spot(param_14, param_15, param_16, param_17, param_18, param_19, param_20);
                attenuation_1 = param_19;
                projector_color = param_20;
                float volume_attenuation_1 = _1661;
                light_color = vec3((light.diffuse.xyz * light.intensity) * volume_attenuation_1);
                if (false)
                {
                    Cone cone_1 = Cone(light.cutoff * 1.0, light.range * 2.0, light.position, light.direction);
                    Ray ray_1 = Ray(_424.basic_params.camera_position, normalize(vFrustum.xyz));
                    float max_t_1 = depth;
                    float vv_1 = 0.0;
                    Cone param_21 = cone_1;
                    Ray param_22 = ray_1;
                    float param_23 = max_t_1;
                    bool _1709 = intersect_cone(param_21, param_22, param_23, param_24, param_25);
                    vv_1 = param_24;
                    vec2 intersections = param_25;
                    if (_1709 == true)
                    {
                        if (intersections.y < intersections.x)
                        {
                            float t = intersections.x;
                            intersections.x = intersections.y;
                            intersections.y = t;
                        }
                        if (intersections.x < 0.0)
                        {
                            intersections.x = 0.0;
                        }
                    }
                }
                outLightColor += light_color;
            }
        }
    }
    outColor = vec4(outLightColor * 0.100000001490116119384765625, outOpacity);
}

 