#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 32, local_size_y = 32, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct BuildRTShadowbufferDispatchElementsParams
{
    uint active_light_idx;
    uint material_flags;
    uint width_in_tiles;
    uint min_rate;
    uint max_rate;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 3, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _334;

layout(set = 0, binding = 4, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 0, binding = 5, std140) uniform BuildRTShadowbufferDispatchElementsParamsBuffer
{
    BuildRTShadowbufferDispatchElementsParams params;
} _408;

layout(set = 0, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 2, std430) buffer buff_dispatch_elements
{
    uint dispatch_elements[];
} _652;

layout(set = 0, binding = 6) uniform usampler2D imNormalMaterial;
layout(set = 0, binding = 7) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 8) uniform usampler2D imMetalnessRoughnessMaterialTags;

shared uint dispatch_count;

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _187;
    if (nor.x > 0.0)
    {
        _187 = -t;
    }
    else
    {
        _187 = t;
    }
    nor.x += _187;
    float _202;
    if (nor.y > 0.0)
    {
        _202 = -t;
    }
    else
    {
        _202 = t;
    }
    nor.y += _202;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

float linearizeDepth(float d)
{
    return _334.dispatch_setup.near_far_plane.z / ((_334.dispatch_setup.near_far_plane.y + _334.dispatch_setup.near_far_plane.x) - (d * _334.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_334.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

uint pack_dispatch(uint x, uint y, uint rate, uint mask)
{
    return (((mask << uint(26)) | (rate << uint(24))) | (y << uint(12))) | x;
}

uint dispatch_get_mask(uint dispatch)
{
    return (dispatch >> uint(26)) & 15u;
}

ivec2 dispatch_get_subsample_offset(uint dispatch)
{
    uint param = dispatch;
    uint mask = dispatch_get_mask(param);
    if ((mask & 1u) != 0u)
    {
        return ivec2(0);
    }
    else
    {
        if ((mask & 2u) != 0u)
        {
            return ivec2(1, 0);
        }
        else
        {
            if ((mask & 4u) != 0u)
            {
                return ivec2(0, 1);
            }
            else
            {
                return ivec2(1);
            }
        }
    }
}

void main()
{
    uvec2 tile_pos = (gl_WorkGroupID.xy * uvec2(32u)) * uvec2(2u);
    bool _381 = gl_LocalInvocationID.x == 0u;
    bool _387;
    if (_381)
    {
        _387 = gl_LocalInvocationID.y == 0u;
    }
    else
    {
        _387 = _381;
    }
    if (_387)
    {
        dispatch_count = 0u;
    }
    barrier();
    LightProperties _415;
    _415.diffuse = lights.light_properties[_408.params.active_light_idx].diffuse;
    _415.direction = lights.light_properties[_408.params.active_light_idx].direction;
    _415.position = lights.light_properties[_408.params.active_light_idx].position;
    _415.up = lights.light_properties[_408.params.active_light_idx].up;
    _415.right = lights.light_properties[_408.params.active_light_idx].right;
    _415.dimensions = lights.light_properties[_408.params.active_light_idx].dimensions;
    _415.lighting_exclusion_tags = lights.light_properties[_408.params.active_light_idx].lighting_exclusion_tags;
    _415.intensity = lights.light_properties[_408.params.active_light_idx].intensity;
    _415.range = lights.light_properties[_408.params.active_light_idx].range;
    _415.cutoff = lights.light_properties[_408.params.active_light_idx].cutoff;
    _415.roughness_modifier = lights.light_properties[_408.params.active_light_idx].roughness_modifier;
    _415.is_area = lights.light_properties[_408.params.active_light_idx].is_area;
    _415.type = lights.light_properties[_408.params.active_light_idx].type;
    _415.projector_sampler = lights.light_properties[_408.params.active_light_idx].projector_sampler;
    _415.projector_intensity = lights.light_properties[_408.params.active_light_idx].projector_intensity;
    _415.downsampled_shadowmap_sampler = lights.light_properties[_408.params.active_light_idx].downsampled_shadowmap_sampler;
    _415.shadowmap_sampler0 = lights.light_properties[_408.params.active_light_idx].shadowmap_sampler0;
    _415.shadowmap_sampler1 = lights.light_properties[_408.params.active_light_idx].shadowmap_sampler1;
    _415.shadowmap_sampler2 = lights.light_properties[_408.params.active_light_idx].shadowmap_sampler2;
    _415.shadowmap_sampler3 = lights.light_properties[_408.params.active_light_idx].shadowmap_sampler3;
    _415.cascade_distance0 = lights.light_properties[_408.params.active_light_idx].cascade_distance0;
    _415.cascade_distance1 = lights.light_properties[_408.params.active_light_idx].cascade_distance1;
    _415.cascade_distance2 = lights.light_properties[_408.params.active_light_idx].cascade_distance2;
    _415.cascade_distance3 = lights.light_properties[_408.params.active_light_idx].cascade_distance3;
    _415.angular_falloff_power = lights.light_properties[_408.params.active_light_idx].angular_falloff_power;
    _415.angular_falloff_color_gradient_idx = lights.light_properties[_408.params.active_light_idx].angular_falloff_color_gradient_idx;
    _415.mat_shadow_mv = lights.light_properties[_408.params.active_light_idx].mat_shadow_mv;
    _415.mat_shadow_p[0] = lights.light_properties[_408.params.active_light_idx].mat_shadow_p[0];
    _415.mat_shadow_p[1] = lights.light_properties[_408.params.active_light_idx].mat_shadow_p[1];
    _415.mat_shadow_p[2] = lights.light_properties[_408.params.active_light_idx].mat_shadow_p[2];
    _415.mat_shadow_p[3] = lights.light_properties[_408.params.active_light_idx].mat_shadow_p[3];
    _415.mat_shadow_mvp[0] = lights.light_properties[_408.params.active_light_idx].mat_shadow_mvp[0];
    _415.mat_shadow_mvp[1] = lights.light_properties[_408.params.active_light_idx].mat_shadow_mvp[1];
    _415.mat_shadow_mvp[2] = lights.light_properties[_408.params.active_light_idx].mat_shadow_mvp[2];
    _415.mat_shadow_mvp[3] = lights.light_properties[_408.params.active_light_idx].mat_shadow_mvp[3];
    LightProperties light = _415;
    uint mask = 0u;
    uint mask_count = 0u;
    for (int iy = 0; iy < 2; iy++)
    {
        for (int ix = 0; ix < 2; ix++)
        {
            uvec2 pixel_pos_in_tile = (gl_LocalInvocationID.xy * uvec2(2u)) + uvec2(uint(ix), uint(iy));
            uvec2 pos = tile_pos + pixel_pos_in_tile;
            bool is_affected = true;
            vec3 origin = _334.dispatch_setup.camera_position;
            DispatchDeferredParams _465;
            _465.mat_projection = _334.dispatch_setup.mat_projection;
            _465.mat_projection_previous = _334.dispatch_setup.mat_projection_previous;
            _465.mat_model = _334.dispatch_setup.mat_model;
            _465.mat_model_previous = _334.dispatch_setup.mat_model_previous;
            _465.mat_view_inverse = _334.dispatch_setup.mat_view_inverse;
            _465.mat_view_previous = _334.dispatch_setup.mat_view_previous;
            _465.camera_position = _334.dispatch_setup.camera_position;
            _465.camera_projection_params = _334.dispatch_setup.camera_projection_params;
            _465.camera_projection_params_previous = _334.dispatch_setup.camera_projection_params_previous;
            _465.near_far_plane = _334.dispatch_setup.near_far_plane;
            _465.resolution = _334.dispatch_setup.resolution;
            _465.inv_resolution = _334.dispatch_setup.inv_resolution;
            _465.frustum_shift = _334.dispatch_setup.frustum_shift;
            DispatchDeferredParams param = _465;
            vec2 param_1 = vec2(pos);
            vec3 view_direction = deferred_get_view_direction_from_screen_pos(param, param_1);
            uint encoded_normal_material = texelFetch(imNormalMaterial, ivec2(pos), 0).x;
            uint param_2 = encoded_normal_material;
            vec3 _482 = decode_normal(param_2);
            vec3 normal = normalize(_482);
            float param_3 = texelFetch(sTextureDepth, ivec2(pos), 0).x;
            float depth = linearizeDepth(param_3);
            vec3 param_4 = view_direction;
            float param_5 = depth;
            vec3 view_coords = positionFromDepth(param_4, param_5);
            vec3 dir = vec3(0.0, 1.0, 0.0);
            if ((light.type & 6) != 0)
            {
                float d = length(light.position - view_coords);
                bool _518 = d > 0.0;
                bool _525;
                if (_518)
                {
                    _525 = d < light.range;
                }
                else
                {
                    _525 = _518;
                }
                if (_525)
                {
                    dir = normalize(light.position - view_coords);
                }
                else
                {
                    is_affected = false;
                }
            }
            if ((light.type & 1) != 0)
            {
                dir = -normalize(light.direction);
            }
            bool _552;
            if (is_affected)
            {
                _552 = dot(dir, normal) < 0.0;
            }
            else
            {
                _552 = is_affected;
            }
            if (_552)
            {
                is_affected = false;
            }
            if (pos.y >= 1080u)
            {
                is_affected = false;
            }
            uvec4 param_6 = texelFetch(imMetalnessRoughnessMaterialTags, ivec2(pos), 0);
            MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_6);
            uint materialIndex = metalness_roughness_material_tags.material_index;
            MaterialPropertiesGPU _586;
            _586.diffuse = materials.material_properties[materialIndex].diffuse;
            _586.transparency = materials.material_properties[materialIndex].transparency;
            _586.emissive = materials.material_properties[materialIndex].emissive;
            _586.roughness = materials.material_properties[materialIndex].roughness;
            _586.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
            _586.refraction = materials.material_properties[materialIndex].refraction;
            _586.normal_factor = materials.material_properties[materialIndex].normal_factor;
            _586.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
            _586.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
            _586.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
            _586.metalness = materials.material_properties[materialIndex].metalness;
            _586.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
            _586.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
            _586.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
            _586.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
            _586.flags = materials.material_properties[materialIndex].flags;
            _586._pad0 = materials.material_properties[materialIndex]._pad0;
            _586._pad1 = materials.material_properties[materialIndex]._pad1;
            MaterialPropertiesGPU material = _586;
            uint material_flags = material.flags;
            bool is_matching = (material_flags & _408.params.material_flags) != 0u;
            if (is_affected)
            {
                mask |= uint(1 << ((iy << 1) | ix));
                mask_count++;
            }
        }
    }
    if (mask_count == 0u)
    {
        return;
    }
    uint base_tile_idx = ((gl_WorkGroupID.y * _408.params.width_in_tiles) + gl_WorkGroupID.x) * 4097u;
    uint base_dispatch_idx = base_tile_idx + 1u;
    uvec2 base_2x2_pos = tile_pos + (gl_LocalInvocationID.xy * uvec2(2u));
    if ((_408.params.max_rate == 0u) || (mask_count == 1u))
    {
        uint _657 = atomicAdd(_652.dispatch_elements[base_tile_idx], mask_count);
        uint idx = _657;
        if ((mask & 1u) != 0u)
        {
            uint param_7 = base_2x2_pos.x + 0u;
            uint param_8 = base_2x2_pos.y + 0u;
            uint param_9 = 0u;
            uint param_10 = 1u;
            _652.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_7, param_8, param_9, param_10);
            idx++;
        }
        if ((mask & 2u) != 0u)
        {
            uint param_11 = base_2x2_pos.x + 1u;
            uint param_12 = base_2x2_pos.y + 0u;
            uint param_13 = 0u;
            uint param_14 = 1u;
            _652.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_11, param_12, param_13, param_14);
            idx++;
        }
        if ((mask & 4u) != 0u)
        {
            uint param_15 = base_2x2_pos.x + 0u;
            uint param_16 = base_2x2_pos.y + 1u;
            uint param_17 = 0u;
            uint param_18 = 1u;
            _652.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_15, param_16, param_17, param_18);
            idx++;
        }
        if ((mask & 8u) != 0u)
        {
            uint param_19 = base_2x2_pos.x + 1u;
            uint param_20 = base_2x2_pos.y + 1u;
            uint param_21 = 0u;
            uint param_22 = 1u;
            _652.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_19, param_20, param_21, param_22);
            idx++;
        }
        return;
    }
    uint refinement_mask = 0u;
    if (false)
    {
        if (_408.params.max_rate == 3u)
        {
            uint param_23 = base_2x2_pos.x + 0u;
            uint param_24 = base_2x2_pos.y + 0u;
            uint param_25 = 3u;
            uint param_26 = mask;
            uint dispatch = pack_dispatch(param_23, param_24, param_25, param_26);
            uint param_27 = dispatch;
            uvec2 offset_in_dispatch = uvec2(dispatch_get_subsample_offset(param_27));
            uvec2 pixel_pos_in_tile_1 = gl_LocalInvocationID.xy * uvec2(2u);
            uvec2 pos_1 = (tile_pos + pixel_pos_in_tile_1) + offset_in_dispatch;
            uint encoded_normal_material_1 = texelFetch(imNormalMaterial, ivec2(pos_1), 0).x;
            uint param_28 = encoded_normal_material_1;
            vec3 _795 = decode_normal(param_28);
            vec3 base_normal = normalize(_795);
            uint base_mask = uint(1 << findLSB(mask));
            if (((mask & 2u) != 0u) && (base_mask != 2u))
            {
                uint encoded_normal_material_2 = texelFetch(imNormalMaterial, ivec2(pos_1) + ivec2(1, 0), 0).x;
                uint param_29 = encoded_normal_material_2;
                vec3 _821 = decode_normal(param_29);
                vec3 normal_1 = normalize(_821);
                float d_1 = abs(dot(normal_1, base_normal));
                if (d_1 < 0.5)
                {
                    refinement_mask |= 2u;
                }
            }
            if (((mask & 4u) != 0u) && (base_mask != 4u))
            {
                uint encoded_normal_material_3 = texelFetch(imNormalMaterial, ivec2(pos_1) + ivec2(0, 1), 0).x;
                uint param_30 = encoded_normal_material_3;
                vec3 _853 = decode_normal(param_30);
                vec3 normal_2 = normalize(_853);
                float d_2 = abs(dot(normal_2, base_normal));
                if (d_2 < 0.5)
                {
                    refinement_mask |= 4u;
                }
            }
            if (((mask & 8u) != 0u) && (base_mask != 8u))
            {
                uint encoded_normal_material_4 = texelFetch(imNormalMaterial, ivec2(pos_1) + ivec2(1), 0).x;
                uint param_31 = encoded_normal_material_4;
                vec3 _885 = decode_normal(param_31);
                vec3 normal_3 = normalize(_885);
                float d_3 = abs(dot(normal_3, base_normal));
                if (d_3 < 0.5)
                {
                    refinement_mask |= 8u;
                }
            }
        }
    }
    uint refinement_count = uint(bitCount(refinement_mask));
    mask &= (~refinement_mask);
    uint _911 = atomicAdd(_652.dispatch_elements[base_tile_idx], 1u + refinement_count);
    uint idx_1 = _911;
    uint param_32 = base_2x2_pos.x + 0u;
    uint param_33 = base_2x2_pos.y + 0u;
    uint param_34 = 3u;
    uint param_35 = mask;
    _652.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_32, param_33, param_34, param_35);
    idx_1++;
    if ((refinement_mask & 2u) != 0u)
    {
        uint param_36 = base_2x2_pos.x + 1u;
        uint param_37 = base_2x2_pos.y + 0u;
        uint param_38 = 0u;
        uint param_39 = 1u;
        _652.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_36, param_37, param_38, param_39);
        idx_1++;
    }
    if ((refinement_mask & 4u) != 0u)
    {
        uint param_40 = base_2x2_pos.x + 0u;
        uint param_41 = base_2x2_pos.y + 1u;
        uint param_42 = 0u;
        uint param_43 = 1u;
        _652.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_40, param_41, param_42, param_43);
        idx_1++;
    }
    if ((refinement_mask & 8u) != 0u)
    {
        uint param_44 = base_2x2_pos.x + 1u;
        uint param_45 = base_2x2_pos.y + 1u;
        uint param_46 = 0u;
        uint param_47 = 1u;
        _652.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_44, param_45, param_46, param_47);
        idx_1++;
    }
}

 